package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: 修改 灰度配置
 *
 * @Author xiezhongyong
 * @Date 2021-10-15
 */
@Data
public class UpdateCanaryConfig {


    @Length(message = "灰度名称 最多输入100字符", max = 100)
    @ApiModelProperty("灰度名称")
    private String canaryName;

    @Length(message = "灰度描述 最多输入250字符", max = 250)
    @ApiModelProperty("灰度描述")
    private String canaryDesc;

    @Pattern(regexp = "^0$|^1$", message = "状态 不合法")
    @ApiModelProperty("状态 0=启用；1=停用")
    private String status = "0";
}
