package com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 创建导出 模板配置
 *
 * @Author xiezhongyong
 * @Date 2021-05-31
 */
@Data
public class CreateExportTemplate {


    @Valid
    @NotNull(message = "配置方信息 不能为空")
    @ApiModelProperty("配置方信息")
    private CoopConfig coopConfig;

    @NotEmpty(message = "引用模板ID 不能为空")
    @ApiModelProperty("引用模板ID")
    private String refTemplateId;

    @ApiModelProperty("单据类型ID")
    private String billTypeName;

    @ApiModelProperty("模板名称")
    @NotEmpty(message = "模板名称 不能为空")
    private String templateName;


    @ApiModelProperty("模板业务分类 BILL_EXP-结算单导出 INVOICE_EXP-发票导出 SALESBILL_EXP-业务单导出")
    @NotEmpty(message = "模板业务分类 不能为空")
    @Pattern(regexp = "^BILL_EXP$|^INVOICE_EXP$|^SALESBILL_EXP$", message = "模板业务分类 不合法")
    private String businessType;

    @Valid
    @Size(min = 1, max = 500, message = "字段列表 范围值[1-500]")
    @NotNull(message = "字段列表 不能为空")
    private List<FieldInfo> fieldList;

    @Valid
    @NotNull(message = "关联信息 不能为空")
    private BindInfo bindInfo;

    @Data
    public static class FieldInfo{
        @ApiModelProperty("字段名称")
        @NotEmpty(message = "字段名称 不能为空")
        private String fieldName;

        @NotNull(message = "分组下标 不能为空")
        private Integer groupIndex;
    }


    @Data
    public static class BindInfo{
        @NotEmpty(message = "关联对象ID 不能为空")
        @ApiModelProperty("关联对象ID")
        private String bindObjId;
        @ApiModelProperty("关联对象code")
        @NotEmpty(message = "关联对象code 不能为空")
        private String bindObjCode;
        @ApiModelProperty("关联对象名称")
        @NotEmpty(message = "关联对象名称 不能为空")
        private String bindObjName;
        @ApiModelProperty("关联对象类型 1-租户(默认) 2-企业")
        @Pattern(regexp = "^1$|^2$", message = "关联对象类型 不合法")
        private String bindObjType = "1";
    }

    @Data
    public static class CoopConfig{
        @NotEmpty(message = "配置方ID 不能为空")
        @ApiModelProperty("配置方ID(租户ID、企业ID 等)")
        private String configObjId;

        @NotEmpty(message = "配置方名称 不能为空")
        @ApiModelProperty("配置方名称")
        private String configObjName;

        @NotEmpty(message = "配置方code 不能为空")
        @ApiModelProperty("配置方code")
        private String configObjCode;

        @ApiModelProperty("配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置")
        @Pattern(regexp = "^0$|^1$|^2$", message = "配置类型 不合法")
        private String configType = "1";

        @ApiModelProperty("分类ID(默认为通用分类)")
        private String coopConfigClassId = "1";
    }
}
