package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 业务配置项 转换后的状态值
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum BIzFieldStatusEnum {

    Y("Y", "开启"),
    N ("N", "关闭");

    private final String code;
    private final String message;

    BIzFieldStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static BIzFieldStatusEnum fromValue(int code) {
        return Arrays.stream(BIzFieldStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
