package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 配置方未配置时是否接受通用模板 0：接受（默认）；1：不接受
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum CommonFlagEnum {

    ACCEPT(0, "接受（默认）"),
    NOT_ACCEPT (1, "不接受");

    private final Integer code;
    private final String message;

    CommonFlagEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static CommonFlagEnum fromValue(int code) {
        return Arrays.stream(CommonFlagEnum.values())
                .filter(s -> s.code == code)
                .findAny()
                .orElse(null);
    }
}
