package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import java.util.Arrays;

/**
 * Describe: 配置类型 0-购方配置 1-供应商配置 2-渠道商配置
 *
 * @Author xiezhongyong
 * @Date 2020-07-02
 */
public enum ConfigTypeEnum {

    PURCHASER(0, "购方"),
    SELLER(1, "销方(供应商)"),
    CHANNEL(2, "渠道");

    private final Integer code;
    private final String message;

    ConfigTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static ConfigTypeEnum fromValue(int code) {
        return Arrays.stream(ConfigTypeEnum.values())
                .filter(s -> s.code == code)
                .findAny()
                .orElse(null);
    }
}
