package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.*;
import com.xforceplus.ant.coop.rule.center.client.data.cc.validation.LimitValidation;
import com.xforceplus.ant.coop.rule.center.client.data.cc.validation.RangeValueVaildation;
import com.xforceplus.ant.coop.rule.center.client.data.cc.validation.SortVaildation;
import com.xforceplus.ant.coop.rule.center.client.data.cc.validation.TolRangeVaildation;

import java.util.Arrays;

/**
 * Describe: 模板字段限定类型枚举
 * align,colWidth,sort,noEmpty,noChange,noShow,defaultValue,rangeValue,enumValue
 *   align-对齐方式
 *   colWidth-列宽
 *   sort-排序
 *   noEmpty-必输项
 *   noChange-禁改项
 *   noShow-禁显项
 *   defaultValue-默认值
 *   rangeValue-区间值
 *   enumValue-枚举值
 *   tolRange-容差范围
 *   amountType-金额类型
 *
 * @Author xiezhongyong
 * @Date 2020-03-18
 */
public enum FieldLimitEnum {

    /** 规则明细部分*/
    ALIGN("align", "对齐方式", 1, AlignLimit.class),
    DISPLAY_TYPE("displayType","显示方式", 2, DisplayTypeLimit.class),
    COL_WIDTH("colWidth", "列宽", 3, ColWidthLimit.class),
    SORT("sort", "排序", 4, SortLimit.class, new SortVaildation()),
    NO_EMPTY("noEmpty", "必输项", 5, NoEmptyLimit.class),
    NO_CHANGE("noChange", "禁改项", 6, NoChangeLimit.class),
    NO_SHOW("noShow", "禁显项", 7, NoShowLimit.class),
    DEFAULT_VALUE("defaultValue", "默认值", 8, DefaultValueLimit.class),
    RANGE_VALUE("rangeValue", "区间值", 9, RangeValueLimit.class, new RangeValueVaildation()),
    ENUM_VALUE("enumValue", "枚举值", 10, EnumValueLimit.class),
    FIELD_MAPPING("fieldMapping", "字段映射", 11, FieldMappingLimit.class),
    FIXED_ENUM_VALUE("fixedEnumValue", "固定枚举值", 12, FixedEnumValueLimit.class),

    /** 业务配置明细部分*/
    TOL_RANGE("tolRange", "容差范围", 1, TolRangeLimit.class, new TolRangeVaildation()),
    AMOUNT_TYPE("amountType", "金额类型", 2, AmountTypeLimit.class)
    ;

    private final String code;
    private final String message;
    private final Integer sort;
    private final Class limitClass;
    private LimitValidation validation;

    FieldLimitEnum(String code, String message, Integer sort, Class limitClass){
        this.code = code;
        this.message = message;
        this.sort = sort;
        this.limitClass = limitClass;
    }
    FieldLimitEnum(String code, String message, Integer sort, Class limitClass, LimitValidation validation){
        this.code = code;
        this.message = message;
        this.sort = sort;
        this.limitClass = limitClass;
        this.validation = validation;
    }

    public String code(){
        return code;
    }

    public String message(){
        return message;
    }

    public Integer sort(){
        return sort;
    }

    public Class limitClass(){
        return limitClass;
    }

    public LimitValidation validation(){
        return validation;
    }

    public static FieldLimitEnum fromValue(String code) {
        return Arrays.stream(FieldLimitEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }

}
