package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 固定枚举标识(Y:固定，N:非固定(默认)
 * @Author xiezhongyong
 * @Date 2020-05-21
 */
public enum FixedEnumValueEnum {

    Y("Y", "固定"),
    N ("N", "非固定");

    private final String code;
    private final String message;

    FixedEnumValueEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static FixedEnumValueEnum fromValue(String code) {
        return Arrays.stream(FixedEnumValueEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
