package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 字段限制 通用状态 列表
 * @Author xiezhongyong
 * @Date 2020-04-24
 */
public enum LimitStatusEnum {

    ENABLED("0", "启用"),
    DISABLED ("1", "停用");

    private final String code;
    private final String message;

    LimitStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static LimitStatusEnum fromValue(String code) {
        return Arrays.stream(LimitStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
