package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import java.util.Arrays;

/**
 * Describe: 容差单位0-固定金额（默认） 1-百分比
 * @Author xiezhongyong
 * @Date 2020-03-19
 */
public enum ToleranceUnitEnum {

    FIXED_AMOUNT ("0", "固定金额"),
    PERCENT("1", "百分比")
    ;

    private final String code;
    private final String message;

    ToleranceUnitEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static ToleranceUnitEnum fromValue(String code) {
        return Arrays.stream(ToleranceUnitEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
