package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 结算单基础配置
 * 3001001	业务模板	billBasicConfig	结算单基础-配置模板	结算单	3001001
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum BillBasicConfigEnum implements IBasicConfigEnum {

    CHECK_TITLE("coopCheckTitleFlag", "校验发票购方抬头四要素"),
    CHECK_TITLE_SELLER("coopCheckSellerTitleFlag", "校验发票销方抬头四要素"),

    SPLIT_SUB_BILL("coopSplitSubBillFlag", "结算单导入拆分子单"),
    COMBINE_ITEMS("coopMergeItemsBeforeSplit", "结算单拆票前合并明细"),
    MODIFY_BILL("coopModifyBill", "结算单主信息可修改"),
    MODIFY_BILL_ITEM("coopModifyBillItem", "结算单明细可修改"),
    CHECK_AFTER_BILL_CONFIRM("coopCheckAfterBillConfirm", "结算单确认后走审核"),

    // 发票配置
//    NEW_BILL("coopNewBillOnRedDeposeFlag", "红冲作废重生结算单"),
//    ASSOCIATE_CANCEL_AFTER_AUTH("coopAssociateCancelAfterAuth", "认证后可取消关联"),
//    ASSOCIATE_CANCEL_AFTER_SCAN("coopAssociateCancelAfterScan", "扫描后可取消关联"),
//    ASSOCIATE_CANCEL_AFTER_RED("coopAssociateCancelAfterRed", "红冲后可取消关联"),
//    ASSOCIATE_CANCEL_AFTER_ABANDON("coopAssociateCancelAfterAbandon", "作废后可取消关联"),
    BILL_CAN_BE_ABANDON("coopBillCanBeAbandon", "结算单可作废"),
    BACK_FILL_MANY_TAX_RATE("coopBackFillManyTaxRate", "发票回填明细混合税率"),
    SPLIT_BILL_ITEM("coopSplitBillItem", "结算单明细可拆分"),
    PAPER_ELEC_INTER_TRANS("coopPaperElecInterTrans", "准许纸电票互转"),


    // 以下是新增配置
    COOP_BILL_ITEM_MAX_ROWS("coopBillItemMaxRows", "结算单明细最大行数"),
//    COOP_INVOICE_BACKFILL_BLEND_TAX_RATE("coopInvoiceBackfillBlendTaxRate", "发票回填明细混合税率"),
    COOP_PART_ISSUE_SUPPORT_SPLIT("coopPartIssueSupportSplit", "部分开具支持重拆"),
    COOP_BILL_LIST_DEFAULT_BILL_CLASS("coopBillListDefaultBillClass", "结算单列表默认单据分类(关闭:AP单据;开启:AR单据)"),
    COOP_BILL_COVER_IS_AVAILABLE("coopBillCoverIsAvailable", "结算单封面是否可用"),
    COOP_BILL_COVER_IS_AUTO_GENERATE("coopBillCoverIsAutoGenerate", "结算单封面是否自动生成"),
    COOP_BILL_ITEM_SPLIT_GOODS_LIKE("coopBillItemSplitGoodsLike", "结算单明细拆分商品模糊匹配"),
    COOP_BILL_ITEM_UPDATE_GOODS_LIKE("coopBillItemUpdateGoodsLike", "结算单明细修改商品模糊匹配"),
    COOP_BILL_INOUT_DISCOUNT_CONVERT("coopBillInoutDiscountConvert", "允许价内外折扣互转"),
    COOP_BILL_IN_DISCOUNT_RULE("coopBillInDiscountRule", "价内折扣分摊规则(先调整单价再拆分数量,除最后一条外均为整数)"),
    COOP_BILL_INVOICE_TYPE_CONVERT("coopBillInvoiceTypeConvert", "结算单发票类型支持纸电互转"),
    COOP_BILL_ITEM_INVOICE_TYPE_CONVERT("coopBillItemInvoiceTypeConvert", "结算单明细发票类型支持纸电互转"),
    COOP_PRE_INVOICE_TYPE_CONVERT("coopPreInvoiceTypeConvert", "预制发票类型支持纸电互转"),
    COOP_BILL_COVER_IS_FULL_CANCEL_REF("coopBillCoverIsFullCancelRef", "结算单是否支持整单发票取消关联"),
    COOP_BILL_GOODS_TN_IS_NULL_EXCEPTION("coopBillGoodsTnIsNullException", "结算单商品税编为空检验(是否进异常列表,开启:进异常;关闭:不进异常)"),
    COOP_BILL_GOODS_TN_IS_NULL_INTERCEPT("coopBillGoodsTnIsNullIntercept", "结算单商品税编为空检验(是否进截留池,开启:进截留池;关闭:不进截留池)"),
    COOP_BILL_BUSINESS_BILL_TYPE("coopBillBusinessBillType", "结算单类型为AP结算单(启用:AP结算单;停用:AR结算单)"),
    COOP_BILL_SELLER_INVOICE_FLAW_CK("coopBillSellerInvoiceFlawCk", "结算单销方票面信息缺失校验(开启:进异常;关闭:不进异常-默认)"),
    COOP_BILL_ITEM_AMOUNT_WITH_TAX_UPDATE_REMARK("coopBillItemAmountWithTaxUpdateRemark", "结算单明细含税金额修改时是否需要维护修改原因(默认关闭)"),
    COOP_BILL_PAYMENT_METHOD("coopBillPaymentMethod", "是否展示结算单付款计划(启用:付款计划;停用[默认]:付款状态)"),
    COOP_BILL_MAKE_INVOICE_UNIT_CHECK("coopBillMakeInvoiceUnitCheck", "开具时是否校验单位(启用:检验;停用[默认]:不校验)"),
    COOP_BILL_MERGE_RAD_BLUE_BILL_ITEM_AMOUNT("coopBillMergeRadBlueBillItemAmount", "支持红蓝混明细结算单明细金额合并开票(启用:支持;停用:不支持[默认])"),
    COOP_BILL_BACKFILL_BTN_DISABLED_STATE("coopBillBackfillBtnDisabledState", "回填按钮不可见(启用:不可见;停用:可见[默认])"),
    COOP_BILL_REJECT_BTN_IS_ENABLE("coopBillRejectBtnIsEnable", "结算单拒绝按钮是否启用(启用:可用;停用:不可用[默认])"),
    COOP_BILL_IS_PUR_APPLY_RED_INFO_TABLE("coopBillIsPurApplyRedInfoTable", "是否购方申请红字信息表(启用:是;停用:否[默认])"),
    COOP_BILL_IS_REF_FREE_INVOICE("coopBillIsRefFreeInvoice", "结算单是否支持关联游离发票(开启:是;关闭:否[默认])"),
    COOP_BILL_MAKE_LOCK_INVOICE_IS_USABLE("coopBillMakeLockInvoiceIsUsable", "开票完成锁定发票是否可用(开启:可以;关闭:不可用[默认])"),
    COOP_BILL_ITEM_DISCOUNT_IS_UPDATE("coopBillItemDiscountIsUpdate", "结算单明细折扣是否可修改(开启:可以;关闭:不可修改[默认])"),

    BILL_CAN_BE_ABANDON_BACK("coopBillCanBeAbandonBack", "结算单可作废-后端控制(开启:可作废[默认];关闭:不可作废)"),

    ALL("ALL", "全部配置项"),
    UNDEFINED("", "未定义的配置项"),
    ;
    private Integer modelType = 3001001;
    private Long commonTemplateId = 3001001L;


    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    BillBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static BillBasicConfigEnum fromValue(String code) {
        BillBasicConfigEnum anEnum = Arrays.stream(BillBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);

        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
