package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 结算单明细拆分基础配置
 * 3001003	业务模板	billItemSplitCfg	结算单明细拆分-配置模板	结算单	3001003
 *
 * @Author xiezhongyong
 * @Date 2020-06-16
 */
public enum BillItemSplitConfigEnum implements IBasicConfigEnum {

    SPLIT_RULE("splitRule", "拆分方式(关闭状态:保单价;开启状态:保数量)"),

    ALL("ALL", "全部配置项"),
    UNDEFINED("", "未定义的配置项"),
    ;
    private Integer modelType = 3001003;
    private Long commonTemplateId = 3001003L;


    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    BillItemSplitConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static BillItemSplitConfigEnum fromValue(String code) {
        BillItemSplitConfigEnum anEnum = Arrays.stream(BillItemSplitConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
