package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 发票回填配置
 * 3003003	业务模板	invoiceBackfillConfig	发票回填-配置模板	发票	3003003
 *
 * @Author xiezhongyong
 * @Date 2020-08-26
 */
public enum InvoiceBackfillConfigEnum implements IBasicConfigEnum {


    INVOICE_DUTY_FREE_FARM_PRODUCT("invoiceDutyFreeFarmProduct", "发票免税农产品（免农）"),


    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3003003;
    private Long commonTemplateId = 3003003L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    InvoiceBackfillConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static InvoiceBackfillConfigEnum fromValue(String code) {
        InvoiceBackfillConfigEnum anEnum = Arrays.stream(InvoiceBackfillConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
