package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * Describe: 条件查询 规则模板（POST）
 *
 * @Author xiezhongyong
 * @Date 2021-04-05
 */
@Data
public class ListRuleTemplateDetail {

    @ApiModelProperty("配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置")
    private Integer configType = 0;
    @NotNull(message = "配置方ID 不能为空")
    @ApiModelProperty("配置方ID")
    private Long configObjId;
    @ApiModelProperty("关联对象ID")
    private Long bindObjId;
    @NotNull(message = "modelType 不能为空")
    @ApiModelProperty("modelType")
    private Integer modelType;
    @ApiModelProperty("购方配置分类ID")
    private Long coopConfigClassId;
    @ApiModelProperty("数据结构类型 0：列表结构(默认)；1：分组结构")
    @Pattern(regexp = "^0$|^1$", message = "数据结构类型 不合法")
    private String viewType = "0";
    @ApiModelProperty("购方未配置时是否接受通用模板 0：接受（默认）；1：不接受")
    @Pattern(regexp = "^0$|^1$", message = "是否接受通用模板 不合法")
    private String commonFlag = "0";
}
