package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import java.util.List;


/**
 * Describe: 更新配置明细 conditions+limit 部分 （之前通过的批量前端实现比较麻烦）
 *
 * @Author xiezhongyong
 * @Date 2020-05-15
 */
@Data
public class UpdateBizTemplateCfgItemConditions {

        @Pattern(regexp = "^0$|^1$", message = "条件状态 不合法")
        @ApiModelProperty("条件状态 0-停用 1-启用")
        private String conditionStatus;

        @Valid
        @ApiModelProperty("条件列表")
        private Conditions conditions;

        @ApiModelProperty("字段限制列表")
        private List<JSONObject> fieldLimits;

}
