package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.FieldEnumValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * Describe: 购方模板明细修改
 *
 * @Author xiezhongyong
 * @Date 2020-03-18
 */
@Data
public class UpdateDataTemplateItem {
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;
    @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
    @Pattern(message = "字段类型 不合法", regexp = "^a$|^s$|^n$|^d$|^t$|^l$")
    private String fieldType;
    @ApiModelProperty("字段格式化")
    private String fieldFormat;
    @Valid
    @ApiModelProperty("枚举值(前端不传值或者为空 的情况下提交修改相当于删除)")
    private List<FieldEnumValue> fieldEnumValues;
}
