package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 业务模板详情
 *
 * @Author xiezhongyong
 * @Date 2020-04-14
 */
@Data
public class BizTemplateDetail {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板代码")
    private String templateCode;
    @ApiModelProperty("模板分类ID")
    private String templateClassId;
    @ApiModelProperty("模板分类名称")
    private String templateClassName;
    @ApiModelProperty("单据类型ID")
    private String billTypeId;
    @ApiModelProperty("单据类型名称")
    private String billTypeName;
    @ApiModelProperty("模型类型")
    private Integer modelType;
    @ApiModelProperty("模板类型 0-规则模板 1-筛选模板")
    private Integer templateType;
    @ApiModelProperty("通用模板标记 0-否(默认) 1-是")
    private Integer commonFlag;
    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("版本号")
    private String version;

    @ApiModelProperty("规则模板配置明细（模板类型 0-规则模板 && viewType=0(默认) 才有数据）")
    private List<CfgItem> cfgItems;
    @ApiModelProperty("规则模板配置明细（模板类型 0-规则模板 && viewType=1 才有数据）")
    private List<CfgItemGroup> cfgItemGroups;

    @ApiModelProperty("筛选模板配置明细（模板类型 1-筛选模板 && viewType=0(默认) 才有数据）")
    private List<SelectItem> selectItems;
    @ApiModelProperty("筛选模板配置明细（模板类型 1-筛选模板 && viewType=1 才有数据）")
    private List<SelectItemGroup> selectItemGroups;


    /**
     * 基础配置 分组对象
     */
    @Data
    public static class CfgItemGroup {
        @ApiModelProperty("字段分组代码")
        private String fieldGroup;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段列表")
        private List<CfgGroupItem> items;
    }

    /**
     * 基础配置 列表对象
     */
    @Data
    public static class CfgItem extends CfgGroupItem {
        @ApiModelProperty("字段分组")
        private String fieldGroup;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
    }

    /**
     * 基础配置 分组列表对象
     */
    @Data
    public static class CfgGroupItem {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段值 0-启用 1-停用")
        private Integer fieldValue;
        @ApiModelProperty("条件开关 0支持配置 1-不支持配置")
        private Integer conditionActive;
        @ApiModelProperty("条件类型 0-生效条件 1-失效条件")
        private Integer conditionType;
        @ApiModelProperty("条件状态 0-启用 1-停用")
        private Integer conditionStatus;
        @ApiModelProperty("条件MD5")
        private String conditionMd5;
        @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
        private String fieldLimitType;
        @ApiModelProperty("条件表达式")
        private String conditionExp;
        @ApiModelProperty("字段限制对象列表")
        private List<JSONObject> fieldLimits;
        @ApiModelProperty("条件列表")
        private Conditions conditions;
    }



    /**
     * 检验配置 分组对象
     */
    @Data
    public static class SelectItemGroup {
        @ApiModelProperty("字段分组代码")
        private String fieldGroup;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段列表")
        private List<SelectGroupItem> items;
    }

    /**
     * 检验配置 列表对象
     */
    @Data
    public static class SelectItem extends SelectGroupItem {
        @ApiModelProperty("字段分组")
        private String fieldGroup;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
    }

    /**
     * 检验配置 分组列表对象
     */
    @Data
    public static class SelectGroupItem {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型")
        private String fieldType;
        @ApiModelProperty("筛选字段名")
        private String selectFieldName;
        @ApiModelProperty("筛选字段中文名称")
        private String selectFieldDisplayName;
        @ApiModelProperty("筛选字段类型")
        private String selectFieldType;
        @ApiModelProperty("字段显示顺序")
        private Integer fieldShowSort;
        @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
        private String fieldLimitType;
        @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
        private Integer extFalg;
        @ApiModelProperty("字段限制对象列表")
        private List<JSONObject> fieldLimits;
    }
}
