package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.FieldEnumValue;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Describe: 规则模板明细 列表
 *
 * @Author xiezhongyong
 * @Date 2020-03-27
 */
@Data
public class ListRuleTemplateItem {

    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板ID")
    private String templateId;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;
    @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
    private String fieldType;
    @ApiModelProperty("字段格式化")
    private String fieldFormat;
    @ApiModelProperty("字段显示顺序")
    private Integer fieldShowSort;
    @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
    private String fieldLimitType;
    @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
    private Integer extFalg;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("枚举值对象列表")
    private List<FieldEnumValue> fieldEnumValues;
    @ApiModelProperty("字段限制对象列表")
    private List<FieldLimit> fieldLimits;
}
