package com.xforceplus.ant.coop.rule.center.client.data.cc.tool;

import com.xforceplus.ant.coop.rule.center.client.api.cc.RuleTemplateConfigApi;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.CommonFlagEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.ConfigTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.TcModelTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.ViewTypeEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetRuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.ListRuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetRuleTemplate;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.RuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * Describe: 规则配置处理工具类
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
@Slf4j
public class RuleTemplateConfigTool {


    /**
     * 读取购方规则配置
     *
     * @param api
     * @param tcModelTypeEnum
     * @param configObjId
     * @param viewType
     * @param commonFlag
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, TcModelTypeEnum tcModelTypeEnum, String billTypeName, Long coopConfigClassId, Long configObjId, ViewTypeEnum viewType, CommonFlagEnum commonFlag) {
        // 模板modelType
        Integer modelType = tcModelTypeEnum.code();
        BaseResult<RuleTemplateDetail> baseResult = getRuleDetail(api, ConfigTypeEnum.PURCHASER, tcModelTypeEnum, billTypeName, coopConfigClassId, configObjId, null, viewType, commonFlag);
        log.info("##### 通过RuleTemplateConfigTool读取规则配置，modelType:{};billTypeName:{};coopConfigClassId:{};配置方ID:{}; 响应内容：{}", modelType, billTypeName, coopConfigClassId, configObjId, JsonUtils.writeObjectToFastJson(baseResult));
        return baseResult;
    }

    /**
     * 读取规则配置
     *
     * @param api
     * @param configType
     * @param bindObjId       关联对象ID
     * @param tcModelTypeEnum
     * @param configObjId
     * @param viewType
     * @param commonFlag
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, ConfigTypeEnum configType, TcModelTypeEnum tcModelTypeEnum, String billTypeName, Long coopConfigClassId, Long configObjId, Long bindObjId, ViewTypeEnum viewType, CommonFlagEnum commonFlag) {
        // 模板modelType
        Integer modelType = tcModelTypeEnum.code();

        GetRuleTemplateDetail request = new GetRuleTemplateDetail();
        request.setConfigType(configType.code());
        request.setModelType(tcModelTypeEnum.code());
        request.setBillTypeName(billTypeName);
        request.setCoopConfigClassId(coopConfigClassId);
        request.setConfigObjId(configObjId);
        request.setBindObjId(bindObjId);
        request.setViewType(viewType.code().toString());
        request.setCommonFlag(commonFlag.code().toString());
        BaseResult<RuleTemplateDetail> baseResult = getRuleDetail(api, request);
        log.info("##### 通过RuleTemplateConfigTool读取规则配置，configType:{};modelType:{};bindObjId:{};billTypeName:{};coopConfigClassId:{};配置方ID:{}; 响应内容：{}", configType, modelType, bindObjId, billTypeName, coopConfigClassId, configObjId, JsonUtils.writeObjectToFastJson(baseResult));
        return baseResult;
    }

    /**
     * 读取规则配置
     *
     * @param api
     * @param configType
     * @param bindObjId       关联对象ID
     * @param tcModelTypeEnum
     * @param configObjId
     * @param commonFlag
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, ConfigTypeEnum configType, TcModelTypeEnum tcModelTypeEnum, Long configObjId, Long bindObjId, CommonFlagEnum commonFlag) {
        // 模板modelType
        Integer modelType = tcModelTypeEnum.code();
        GetRuleTemplateDetail request = new GetRuleTemplateDetail();
        request.setConfigType(configType.code());
        request.setModelType(tcModelTypeEnum.code());
        request.setConfigObjId(configObjId);
        request.setBindObjId(bindObjId);
        request.setCommonFlag(commonFlag.code().toString());
        BaseResult<RuleTemplateDetail> baseResult = getRuleDetail(api, request);
        log.info("##### 通过RuleTemplateConfigTool读取规则配置，configType:{};modelType:{};bindObjId:{};配置方ID:{}; 响应内容：{}", configType, modelType, bindObjId, configObjId, JsonUtils.writeObjectToFastJson(baseResult));
        return baseResult;
    }

    /**
     * 读取规则配置
     *
     * @param api
     * @param request
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, GetRuleTemplateDetail request) {
        return api.getRuleDetailPost(request);
    }


    /**
     * 读取规则配置
     *
     * @param api
     * @param tcModelTypeEnum
     * @param configObjId
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, TcModelTypeEnum tcModelTypeEnum, Long configObjId) {
        return getRuleDetail(api, tcModelTypeEnum, null, null, configObjId, ViewTypeEnum.LIST, CommonFlagEnum.ACCEPT);
    }

    /**
     * 读取规则配置
     *
     * @param api
     * @param tcModelTypeEnum
     * @param configObjId
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, TcModelTypeEnum tcModelTypeEnum, Long configObjId, CommonFlagEnum commonFlag) {
        return getRuleDetail(api, tcModelTypeEnum, null, null, configObjId, ViewTypeEnum.LIST, commonFlag);
    }

    /**
     * 读取规则配置：支持单据类型
     *
     * @param api
     * @param tcModelTypeEnum
     * @param configObjId
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, TcModelTypeEnum tcModelTypeEnum, Long configObjId, String billTypeName, CommonFlagEnum commonFlag) {
        return getRuleDetail(api, tcModelTypeEnum, billTypeName, null, configObjId, ViewTypeEnum.LIST, commonFlag);
    }

    /**
     * 读取规则配置
     *
     * @param api
     * @param tcModelTypeEnum
     * @param configObjId
     * @return
     */
    public static BaseResult<RuleTemplateDetail> getRuleDetail(RuleTemplateConfigApi api, TcModelTypeEnum tcModelTypeEnum, Long configObjId, String billTypeName) {
        return getRuleDetail(api, tcModelTypeEnum, billTypeName, null, configObjId, ViewTypeEnum.LIST, CommonFlagEnum.ACCEPT);
    }


    /**
     * 读取规则配置(不支持单据类型，返回列表，购方未配置的情况下返回系统通过模板，反之不返回)
     *
     * @param api
     * @param configType
     * @param tcModelTypeEnum
     * @param coopConfigClassId
     * @param configObjId
     * @param bindObjId
     * @param viewType
     * @param commonFlag
     * @return
     */
    public static BaseResult<List<RuleTemplateDetail>> listRuleDetail(RuleTemplateConfigApi api, ConfigTypeEnum configType, TcModelTypeEnum tcModelTypeEnum, Long coopConfigClassId, Long configObjId, Long bindObjId, ViewTypeEnum viewType, CommonFlagEnum commonFlag) {
        // 模板modelType
        Integer modelType = tcModelTypeEnum.code();

        ListRuleTemplateDetail request = new ListRuleTemplateDetail();
        request.setConfigType(configType.code());
        request.setModelType(tcModelTypeEnum.code());
        request.setCoopConfigClassId(coopConfigClassId);
        request.setConfigObjId(configObjId);
        request.setBindObjId(bindObjId);
        request.setViewType(viewType.code().toString());
        request.setCommonFlag(commonFlag.code().toString());
        BaseResult<List<RuleTemplateDetail>> baseResult = api.listRuleDetailPost(request);
        log.info("##### 通过RuleTemplateConfigTool读取规则配置列表，configType:{};modelType:{};bindObjId:{};coopConfigClassId:{};配置方ID:{}; 响应内容：{}", configType, modelType, bindObjId, coopConfigClassId, configObjId, JsonUtils.writeObjectToFastJson(baseResult));
        return baseResult;
    }


    /**
     * 读取规则配置(不支持单据类型，返回列表，购方未配置的情况下返回系统通过模板，反之不返回)
     * 该方法默认接收 List 格式，不支持购销对查询
     * @param api
     * @param configType
     * @param tcModelTypeEnum
     * @param configObjId
     * @return
     */
    public static BaseResult<List<RuleTemplateDetail>> listRuleDetail(RuleTemplateConfigApi api, ConfigTypeEnum configType, TcModelTypeEnum tcModelTypeEnum, Long configObjId, CommonFlagEnum commonFlag) {
        return listRuleDetail(api, configType, tcModelTypeEnum, null, configObjId, null, ViewTypeEnum.LIST, commonFlag);
    }
}
