package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonInclude(NON_NULL)
public class QueryTaxDeviceInfoRequest {
  @JsonProperty("deviceType")
  private String deviceType = null;

    @JsonProperty("taxDeviceType")
    private Integer taxDeviceType = null;

  @JsonProperty("companyTenantId")
  private Long companyTenantId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

    @JsonProperty("taxNo")
    private String taxNo = null;

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("status")
  private List<Integer> status = new ArrayList<Integer>();

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public QueryTaxDeviceInfoRequest deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * （必须）设备类型，taxDevice：税控设备，UKey：UKey，taxVUKey:税控设备-VUKey
   * @return deviceType
  **/
  @ApiModelProperty(value = "（必须）设备类型，taxDevice：税控设备，UKey：UKey，taxVUKey:税控设备-VUKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest companyTenantId(Long companyTenantId) {
    this.companyTenantId = companyTenantId;
    return this;
  }

    @ApiModelProperty("1 百望单盘 2 百望服务器 3 航信单盘 4 航信服务器 5 虚拟UKey设备 8 税务UKey设备 7 税务证书")
    public Integer getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    /**
   * 公司所属的租户Id
   * @return companyTenantId
  **/
  @ApiModelProperty(value = "公司所属的租户Id")
  public Long getCompanyTenantId() {
    return companyTenantId;
  }

  public void setCompanyTenantId(Long companyTenantId) {
    this.companyTenantId = companyTenantId;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    /**
   * 公司Id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司Id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public QueryTaxDeviceInfoRequest addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账）
   * @return supportService
  **/
  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest status(List<Integer> status) {
    this.status = status;
    return this;
  }

  public QueryTaxDeviceInfoRequest addStatusItem(Integer statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用）
   * @return status
  **/
  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用）")
  public List<Integer> getStatus() {
    return status;
  }

  public void setStatus(List<Integer> status) {
    this.status = status;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public QueryTaxDeviceInfoRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryTaxDeviceInfoRequest queryTaxDeviceInfoRequest = (QueryTaxDeviceInfoRequest) o;
    return Objects.equals(this.deviceType, queryTaxDeviceInfoRequest.deviceType) &&
        Objects.equals(this.companyTenantId, queryTaxDeviceInfoRequest.companyTenantId) &&
        Objects.equals(this.companyId, queryTaxDeviceInfoRequest.companyId) &&
        Objects.equals(this.supportService, queryTaxDeviceInfoRequest.supportService) &&
        Objects.equals(this.status, queryTaxDeviceInfoRequest.status) &&
        Objects.equals(this.pageNo, queryTaxDeviceInfoRequest.pageNo) &&
        Objects.equals(this.pageSize, queryTaxDeviceInfoRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceType, companyTenantId, companyId, supportService, status, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryTaxDeviceInfoRequest {\n");

    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    companyTenantId: ").append(toIndentedString(companyTenantId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
