package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * UpdateTaxDeviceStatusRequest
 */

@JsonInclude(NON_NULL)
public class UpdateTaxDeviceStatusRequest {
  @JsonProperty("deviceId")
  private List<Long> deviceId = new ArrayList<Long>();

  @JsonProperty("deviceUn")
  private List<String> deviceUn = new ArrayList<String>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public UpdateTaxDeviceStatusRequest deviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  public UpdateTaxDeviceStatusRequest addDeviceIdItem(Long deviceIdItem) {
    this.deviceId.add(deviceIdItem);
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备id")
  public List<Long> getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public UpdateTaxDeviceStatusRequest deviceUn(List<String> deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

  public UpdateTaxDeviceStatusRequest addDeviceUnItem(String deviceUnItem) {
    this.deviceUn.add(deviceUnItem);
    return this;
  }

   /**
   * 设备联合Id
   * @return deviceUn
  **/
  @ApiModelProperty(value = "设备联合Id")
  public List<String> getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(List<String> deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public UpdateTaxDeviceStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTaxDeviceStatusRequest updateTaxDeviceStatusRequest = (UpdateTaxDeviceStatusRequest) o;
    return Objects.equals(this.deviceId, updateTaxDeviceStatusRequest.deviceId) &&
        Objects.equals(this.deviceUn, updateTaxDeviceStatusRequest.deviceUn) &&
        Objects.equals(this.status, updateTaxDeviceStatusRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, deviceUn, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTaxDeviceStatusRequest {\n");

    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
