package com.xforceplus.ant.coop.rule.center.client.data.enterprise.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RuleCenterQueryDeviceResponse
 */

@JsonInclude(NON_NULL)
public class RuleCenterQueryDeviceResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("devices")
  private List<DeviceInfo> devices = new ArrayList<>();

  @JsonProperty("onlineDeviceIds")
  private List<Long> onlineDeviceIds = new ArrayList<>();

  @JsonProperty("onlineDeviceUns")
  private List<String> onlineDeviceUns = new ArrayList<>();

  @JsonProperty("originAccountOnlineDeviceIds")
  private List<Long> originAccountOnlineDeviceIds = new ArrayList<>();

  @JsonProperty("originAccountOnlineDeviceUns")
  private List<String> originAccountOnlineDeviceUns = new ArrayList<>();

  @JsonProperty("pageInfo")
  private ResponsePageInfo pageInfo = null;

  @JsonIgnore
  public RuleCenterQueryDeviceResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 设备信息获取响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "设备信息获取响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse devices(List<DeviceInfo> devices) {
    this.devices = devices;
    return this;
  }

  public RuleCenterQueryDeviceResponse addDevicesItem(DeviceInfo devicesItem) {
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * 设备列表
   * @return devices
  **/

  @Valid

  @ApiModelProperty(value = "设备列表")
  public List<DeviceInfo> getDevices() {
    return devices;
  }

  public void setDevices(List<DeviceInfo> devices) {
    this.devices = devices;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse onlineDeviceIds(List<Long> onlineDeviceIds) {
    this.onlineDeviceIds = onlineDeviceIds;
    return this;
  }

  public RuleCenterQueryDeviceResponse addOnlineDeviceIdsItem(Long onlineDeviceIdsItem) {
    this.onlineDeviceIds.add(onlineDeviceIdsItem);
    return this;
  }

   /**
   * 直连在线设备列表,当查询在线状态参数为true时返回（已废弃，用onlineDeviceUns代替）
   * @return onlineDeviceIds
  **/


  @ApiModelProperty(value = "直连在线设备列表,当查询在线状态参数为true时返回（已废弃，用onlineDeviceUns代替）")
  public List<Long> getOnlineDeviceIds() {
    return onlineDeviceIds;
  }

  public void setOnlineDeviceIds(List<Long> onlineDeviceIds) {
    this.onlineDeviceIds = onlineDeviceIds;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse onlineDeviceUns(List<String> onlineDeviceUns) {
    this.onlineDeviceUns = onlineDeviceUns;
    return this;
  }

  public RuleCenterQueryDeviceResponse addOnlineDeviceUnsItem(String onlineDeviceUnsItem) {
    this.onlineDeviceUns.add(onlineDeviceUnsItem);
    return this;
  }

   /**
   * 直连在线设备列表,当查询在线状态参数为true时返回
   * @return onlineDeviceUns
  **/


  @ApiModelProperty(value = "直连在线设备列表,当查询在线状态参数为true时返回")
  public List<String> getOnlineDeviceUns() {
    return onlineDeviceUns;
  }

  public void setOnlineDeviceUns(List<String> onlineDeviceUns) {
    this.onlineDeviceUns = onlineDeviceUns;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse originAccountOnlineDeviceIds(List<Long> originAccountOnlineDeviceIds) {
    this.originAccountOnlineDeviceIds = originAccountOnlineDeviceIds;
    return this;
  }

  public RuleCenterQueryDeviceResponse addOriginAccountOnlineDeviceIdsItem(Long originAccountOnlineDeviceIdsItem) {
    this.originAccountOnlineDeviceIds.add(originAccountOnlineDeviceIdsItem);
    return this;
  }

   /**
   * 底账在线列表,当查询在线状态参数为true时返回（已废弃，用originAccountOnlineDeviceUns代替）
   * @return originAccountOnlineDeviceIds
  **/


  @ApiModelProperty(value = "底账在线列表,当查询在线状态参数为true时返回（已废弃，用originAccountOnlineDeviceUns代替）")
  public List<Long> getOriginAccountOnlineDeviceIds() {
    return originAccountOnlineDeviceIds;
  }

  public void setOriginAccountOnlineDeviceIds(List<Long> originAccountOnlineDeviceIds) {
    this.originAccountOnlineDeviceIds = originAccountOnlineDeviceIds;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse originAccountOnlineDeviceUns(List<String> originAccountOnlineDeviceUns) {
    this.originAccountOnlineDeviceUns = originAccountOnlineDeviceUns;
    return this;
  }

  public RuleCenterQueryDeviceResponse addOriginAccountOnlineDeviceUnsItem(String originAccountOnlineDeviceUnsItem) {
    this.originAccountOnlineDeviceUns.add(originAccountOnlineDeviceUnsItem);
    return this;
  }

   /**
   * 底账在线列表,当查询在线状态参数为true时返回
   * @return originAccountOnlineDeviceUns
  **/


  @ApiModelProperty(value = "底账在线列表,当查询在线状态参数为true时返回")
  public List<String> getOriginAccountOnlineDeviceUns() {
    return originAccountOnlineDeviceUns;
  }

  public void setOriginAccountOnlineDeviceUns(List<String> originAccountOnlineDeviceUns) {
    this.originAccountOnlineDeviceUns = originAccountOnlineDeviceUns;
  }

  @JsonIgnore
  public RuleCenterQueryDeviceResponse pageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public ResponsePageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RuleCenterQueryDeviceResponse queryDeviceResponse = (RuleCenterQueryDeviceResponse) o;
    return Objects.equals(this.head, queryDeviceResponse.head) &&
        Objects.equals(this.devices, queryDeviceResponse.devices) &&
        Objects.equals(this.onlineDeviceIds, queryDeviceResponse.onlineDeviceIds) &&
        Objects.equals(this.onlineDeviceUns, queryDeviceResponse.onlineDeviceUns) &&
        Objects.equals(this.originAccountOnlineDeviceIds, queryDeviceResponse.originAccountOnlineDeviceIds) &&
        Objects.equals(this.originAccountOnlineDeviceUns, queryDeviceResponse.originAccountOnlineDeviceUns) &&
        Objects.equals(this.pageInfo, queryDeviceResponse.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, devices, onlineDeviceIds, onlineDeviceUns, originAccountOnlineDeviceIds, originAccountOnlineDeviceUns, pageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RuleCenterQueryDeviceResponse {\n");

    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    onlineDeviceIds: ").append(toIndentedString(onlineDeviceIds)).append("\n");
    sb.append("    onlineDeviceUns: ").append(toIndentedString(onlineDeviceUns)).append("\n");
    sb.append("    originAccountOnlineDeviceIds: ").append(toIndentedString(originAccountOnlineDeviceIds)).append("\n");
    sb.append("    originAccountOnlineDeviceUns: ").append(toIndentedString(originAccountOnlineDeviceUns)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
