package com.xforceplus.ant.coop.rule.center.client.data.enterprise.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 税盘订阅
 */
@ApiModel(description = "税盘订阅")

@JsonInclude(NON_NULL)
public class SubscribeDeviceInfo {
  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("createdBy")
  private String createdBy = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;



  @JsonProperty("subscribeValue")
  private String subscribeValue = null;

    @JsonProperty("deviceUn")
    private String deviceUn = null;

  @JsonIgnore
  public SubscribeDeviceInfo updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    /**
   * 更新人姓名
   * @return updatedBy
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  @JsonIgnore
  public SubscribeDeviceInfo createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 创建人姓名
   * @return createdBy
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  @JsonIgnore
  public SubscribeDeviceInfo opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

   /**
   * 订阅值【单张限额订阅，此处填税号】
   * @return subscribeValue
  **/
  @ApiModelProperty(value = "订阅值【单张限额订阅，此处填税号】")
  public String getSubscribeValue() {
    return subscribeValue;
  }

  public void setSubscribeValue(String subscribeValue) {
    this.subscribeValue = subscribeValue;
  }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscribeDeviceInfo that = (SubscribeDeviceInfo) o;
        return Objects.equals(updatedBy, that.updatedBy) &&
                Objects.equals(createdBy, that.createdBy) &&
                Objects.equals(opTenantId, that.opTenantId) &&
                Objects.equals(subscribeValue, that.subscribeValue) &&
                Objects.equals(deviceUn, that.deviceUn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(updatedBy, createdBy, opTenantId, subscribeValue, deviceUn);
    }

    @Override
    public String toString() {
        return "SubscribeDeviceInfo{" +
                "updatedBy='" + updatedBy + '\'' +
                ", createdBy='" + createdBy + '\'' +
                ", opTenantId=" + opTenantId +
                ", subscribeValue='" + subscribeValue + '\'' +
                ", deviceUn='" + deviceUn + '\'' +
                '}';
    }
}
