package com.xforceplus.ant.coop.rule.center.client.data.utils;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 分页信息
 *
 * @Author xiezhongyong
 * @Date 2019-12-15
 */
@Data
public class Page<T> {

    @ApiModelProperty("总数据量(响应参数)")
    private Long total;
    @ApiModelProperty("每页数量(默认值：10)*")
    private Integer size = 10;
    @ApiModelProperty("总页数(响应参数)")
    private Integer pages;
    @ApiModelProperty("当前页码(默认值：1)")
    private Integer page = 1;
    @ApiModelProperty("排序(响应参数)")
    private List<OrderItem> orders = new ArrayList<>();
    @ApiModelProperty("数据列表(响应参数)")
    private List<T> list = new ArrayList<>();
    @ApiModelProperty("排序字符串(请求参数，比如: createTime,ASC = 按创建时间升序。createTime,ASC;id,DESC = 按创建时间升序 和ID降序。)")
    private String sorts;

    public void setSize(Integer size) {
        if(null == size || 0 == size) {
            this.size = 10;
        }
    }
    public void setTotal(Long total) {

        Long totalPage = total / size;
        if (0 != total % size) {
            totalPage++;
        }

        setPages(totalPage.intValue());
        this.total = total;
    }
}
