package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsAddTerminalResult
 */

@JsonInclude(NON_NULL)
public class MsAddTerminalResult {
  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonIgnore
  public MsAddTerminalResult terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public MsAddTerminalResult terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端UN
   * @return terminalUn
  **/
  @ApiModelProperty(value = "终端UN")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAddTerminalResult addTerminalResult = (MsAddTerminalResult) o;
    return Objects.equals(this.terminalId, addTerminalResult.terminalId) &&
        Objects.equals(this.terminalUn, addTerminalResult.terminalUn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalId, terminalUn);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAddTerminalResult {\n");

    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
