package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigTemialQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigTemialQueryRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("terminalInfo")
  private MsTerminalQueryInfo terminalInfo = null;

  @JsonProperty("pageInfo")
  private MsPageInfo pageInfo = null;

  @JsonProperty("sortInfo")
  private MsSortInfo sortInfo = null;

    @JsonProperty("cid")
    private String cid = null;

  @JsonIgnore
  public MsConfigTemialQueryRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsConfigTemialQueryRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsConfigTemialQueryRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsConfigTemialQueryRequest terminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalQueryInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }

  @JsonIgnore
  public MsConfigTemialQueryRequest pageInfo(MsPageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/
  @ApiModelProperty(value = "分页信息")
  public MsPageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(MsPageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  @JsonIgnore
  public MsConfigTemialQueryRequest sortInfo(MsSortInfo sortInfo) {
    this.sortInfo = sortInfo;
    return this;
  }

   /**
   * 排序信息
   * @return sortInfo
  **/
  @ApiModelProperty(value = "排序信息")
  public MsSortInfo getSortInfo() {
    return sortInfo;
  }

  public void setSortInfo(MsSortInfo sortInfo) {
    this.sortInfo = sortInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTemialQueryRequest configTemialQueryRequest = (MsConfigTemialQueryRequest) o;
    return Objects.equals(this.opUserId, configTemialQueryRequest.opUserId) &&
        Objects.equals(this.opUserName, configTemialQueryRequest.opUserName) &&
        Objects.equals(this.opTenantId, configTemialQueryRequest.opTenantId) &&
        Objects.equals(this.terminalInfo, configTemialQueryRequest.terminalInfo) &&
        Objects.equals(this.pageInfo, configTemialQueryRequest.pageInfo) &&
        Objects.equals(this.sortInfo, configTemialQueryRequest.sortInfo);
  }

    public String getCid() {
        return cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, terminalInfo, pageInfo, sortInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigTemialQueryRequest {\n");

    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
