package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端授权信息
 */
@ApiModel(description = "终端授权信息")

@JsonInclude(NON_NULL)
public class MsLicenseInfo {
  @JsonProperty("expireAt")
  private String expireAt = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<String>();

  @JsonIgnore
  public MsLicenseInfo expireAt(String expireAt) {
    this.expireAt = expireAt;
    return this;
  }

   /**
   * 证书到期日期(yyyy/MM/dd)
   * @return expireAt
  **/
  @ApiModelProperty(value = "证书到期日期(yyyy/MM/dd)")
  public String getExpireAt() {
    return expireAt;
  }

  public void setExpireAt(String expireAt) {
    this.expireAt = expireAt;
  }

  @JsonIgnore
  public MsLicenseInfo service(List<String> service) {
    this.service = service;
    return this;
  }

  public MsLicenseInfo addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 授权文件支持的服务 （make：开票 ，print：打印，originAccount：底账）
   * @return service
  **/
  @ApiModelProperty(value = "授权文件支持的服务 （make：开票 ，print：打印，originAccount：底账）")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsLicenseInfo licenseInfo = (MsLicenseInfo) o;
    return Objects.equals(this.expireAt, licenseInfo.expireAt) &&
        Objects.equals(this.service, licenseInfo.service);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expireAt, service);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsLicenseInfo {\n");

    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
