package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.coop.rule.center.client.model.MsListPlatform;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台列表信息返回
 */
@ApiModel(description = "平台列表信息返回")

@JsonInclude(NON_NULL)
public class MsListPlatformResult {
  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("list")
  private List<MsListPlatform> list = new ArrayList<MsListPlatform>();

  @JsonIgnore
  public MsListPlatformResult total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsListPlatformResult list(List<MsListPlatform> list) {
    this.list = list;
    return this;
  }

  public MsListPlatformResult addListItem(MsListPlatform listItem) {
    this.list.add(listItem);
    return this;
  }

   /**
   * Get list
   * @return list
  **/
  @ApiModelProperty(value = "")
  public List<MsListPlatform> getList() {
    return list;
  }

  public void setList(List<MsListPlatform> list) {
    this.list = list;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListPlatformResult listPlatformResult = (MsListPlatformResult) o;
    return Objects.equals(this.total, listPlatformResult.total) &&
        Objects.equals(this.list, listPlatformResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListPlatformResult {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
