package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 库存订阅信息
 */
@ApiModel(description = "税盘库存订阅信息")

@JsonInclude(NON_NULL)
public class MsSubscribeStockInfo {

  @JsonProperty("createdBy")
  private String createdBy = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("subscribeValue")
  private String subscribeValue = null;

  @JsonProperty("subscribeType")
  private Integer subscribeType = null;

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    public String getSubscribeValue() {
        return subscribeValue;
    }

    public void setSubscribeValue(String subscribeValue) {
        this.subscribeValue = subscribeValue;
    }

    public Integer getSubscribeType() {
        return subscribeType;
    }

    public void setSubscribeType(Integer subscribeType) {
        this.subscribeType = subscribeType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MsSubscribeStockInfo that = (MsSubscribeStockInfo) o;
        return Objects.equals(createdBy, that.createdBy) &&
                Objects.equals(deviceUn, that.deviceUn) &&
                Objects.equals(subscribeValue, that.subscribeValue) &&
                Objects.equals(subscribeType, that.subscribeType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(createdBy, deviceUn, subscribeValue, subscribeType);
    }

    @Override
    public String toString() {
        return "MsSubscribeStockInfo{" +
                "createdBy='" + createdBy + '\'' +
                ", deviceUn='" + deviceUn + '\'' +
                ", subscribeValue='" + subscribeValue + '\'' +
                ", subscribeType=" + subscribeType +
                '}';
    }
}
