package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class MsTerminalOnlineDeviceInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("deviceType")
    private String deviceType = null;

    @JsonProperty("status")
    private Integer status = null;

  @JsonIgnore
  public MsTerminalOnlineDeviceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备id，服务器终端时返回
   * @return id
  **/
  @ApiModelProperty(value = "设备id，服务器终端时返回")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsTerminalOnlineDeviceInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备UN
   * @return deviceUn
  **/
  @ApiModelProperty(value = "设备UN")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public MsTerminalOnlineDeviceInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MsTerminalOnlineDeviceInfo that = (MsTerminalOnlineDeviceInfo) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(deviceUn, that.deviceUn) &&
                Objects.equals(deviceName, that.deviceName) &&
                Objects.equals(deviceNo, that.deviceNo) &&
                Objects.equals(deviceType, that.deviceType) &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, deviceUn, deviceName, deviceNo, deviceType, status);
    }

    @Override
    public String toString() {
        return "MsTerminalOnlineDeviceInfo{" +
                "id=" + id +
                ", deviceUn='" + deviceUn + '\'' +
                ", deviceName='" + deviceName + '\'' +
                ", deviceNo='" + deviceNo + '\'' +
                ", deviceType='" + deviceType + '\'' +
                ", status=" + status +
                '}';
    }

    /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
