package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端查询结果
 */
@ApiModel(description = "终端查询结果")

@JsonInclude(NON_NULL)
public class MsTerminalQueryResult {
  @JsonProperty("terminals")
  private List<MsTerminalQueryResponseInfo> terminals = new ArrayList<MsTerminalQueryResponseInfo>();

  @JsonProperty("pageInfo")
  private MsResponsePageInfo pageInfo = null;

  @JsonIgnore
  public MsTerminalQueryResult terminals(List<MsTerminalQueryResponseInfo> terminals) {
    this.terminals = terminals;
    return this;
  }

  public MsTerminalQueryResult addTerminalsItem(MsTerminalQueryResponseInfo terminalsItem) {
    this.terminals.add(terminalsItem);
    return this;
  }

   /**
   * 终端信息
   * @return terminals
  **/
  @ApiModelProperty(value = "终端信息")
  public List<MsTerminalQueryResponseInfo> getTerminals() {
    return terminals;
  }

  public void setTerminals(List<MsTerminalQueryResponseInfo> terminals) {
    this.terminals = terminals;
  }

  @JsonIgnore
  public MsTerminalQueryResult pageInfo(MsResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/
  @ApiModelProperty(value = "分页信息")
  public MsResponsePageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(MsResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTerminalQueryResult terminalQueryResult = (MsTerminalQueryResult) o;
    return Objects.equals(this.terminals, terminalQueryResult.terminals) &&
        Objects.equals(this.pageInfo, terminalQueryResult.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminals, pageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTerminalQueryResult {\n");

    sb.append("    terminals: ").append(toIndentedString(terminals)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
