package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台logo信息
 */
@ApiModel(description = "平台logo信息")

@JsonInclude(NON_NULL)
public class MsUpdatePlatformLogo {
  @JsonProperty("logoUrl")
  private String logoUrl = null;

  @JsonProperty("logoLink")
  private String logoLink = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("defaultFlag")
  private Integer defaultFlag = null;

  @JsonIgnore
  public MsUpdatePlatformLogo logoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
    return this;
  }

   /**
   * logo 地址
   * @return logoUrl
  **/
  @ApiModelProperty(value = "logo 地址")
  public String getLogoUrl() {
    return logoUrl;
  }

  public void setLogoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
  }

  @JsonIgnore
  public MsUpdatePlatformLogo logoLink(String logoLink) {
    this.logoLink = logoLink;
    return this;
  }

   /**
   * logo 链接
   * @return logoLink
  **/
  @ApiModelProperty(value = "logo 链接")
  public String getLogoLink() {
    return logoLink;
  }

  public void setLogoLink(String logoLink) {
    this.logoLink = logoLink;
  }

  @JsonIgnore
  public MsUpdatePlatformLogo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * logo状态  0-启用(默认) 1-停用
   * @return status
  **/
  @ApiModelProperty(value = "logo状态  0-启用(默认) 1-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsUpdatePlatformLogo defaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
    return this;
  }

   /**
   * 默认标记(标记当前logo是否为默认/票易通logo)  0-票易通默认logo(默认) 1-自定义logo
   * @return defaultFlag
  **/
  @ApiModelProperty(value = "默认标记(标记当前logo是否为默认/票易通logo)  0-票易通默认logo(默认) 1-自定义logo")
  public Integer getDefaultFlag() {
    return defaultFlag;
  }

  public void setDefaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdatePlatformLogo updatePlatformLogo = (MsUpdatePlatformLogo) o;
    return Objects.equals(this.logoUrl, updatePlatformLogo.logoUrl) &&
        Objects.equals(this.logoLink, updatePlatformLogo.logoLink) &&
        Objects.equals(this.status, updatePlatformLogo.status) &&
        Objects.equals(this.defaultFlag, updatePlatformLogo.defaultFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(logoUrl, logoLink, status, defaultFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdatePlatformLogo {\n");
    
    sb.append("    logoUrl: ").append(toIndentedString(logoUrl)).append("\n");
    sb.append("    logoLink: ").append(toIndentedString(logoLink)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    defaultFlag: ").append(toIndentedString(defaultFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
