package com.xforceplus.ant.coop.rule.center.common.util;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * Describe:  辅助工具类
 * @Author xiezhongyong
 * @Date 2020-03-29
 */
@Slf4j
public class ReflectUtils {


    public static void setValue(Object obj, String filedName, Object value) {
        try {
            String methodName = "set" + filedName.substring(0, 1).toUpperCase() + filedName.substring(1);
            Method method =  getDeclaredMethod(obj, methodName, value.getClass());
            method.invoke(obj, value);
        }catch (Exception e) {
            log.warn("##### ReflectUtils setValue 字段名称：{} 异常：{}", filedName, e.getMessage());
        }
    }

    public static <V> V getValue(Object obj, String filedName) {
        try {
            String methodName = "get" + filedName.substring(0, 1).toUpperCase() + filedName.substring(1);
            Method method =  getDeclaredMethod(obj, methodName);
            Object invoke = method.invoke(obj);
            return (V)invoke;
        }catch (Exception e) {
            log.warn("##### ReflectUtils getValue 字段名称：{} 异常：{}", filedName, e.getMessage());
        }
        return null;
    }


    /**
     * 获取 set 方法
     * @param object
     * @param methodName
     * @param parameterTypes
     * @return
     */
    private static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes){
        Method method = null ;
        for(Class<?> clazz = object.getClass() ; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes) ;
                return method ;
            } catch (Exception e) {
            }
        }
        return null;
    }

    /**
     * 获取 get 方法
     * @param object
     * @param methodName
     * @return
     */
    public static Method getDeclaredMethod(Object object, String methodName){
        Method method = null ;
        for(Class<?> clazz = object.getClass() ; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName) ;
                return method ;
            } catch (Exception e) {
            }
        }
        return null;
    }
}
