package com.xforceplus.ant.coop.rule.center.client.api.baseconfig;

import com.xforceplus.ant.coop.rule.center.client.data.baseconfig.ListEnterWay;
import com.xforceplus.ant.coop.rule.center.client.data.baseconfig.UpdateEnterWay;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 基础配置-入驻方式 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "enter-way-configs", description = "基础配置-入驻方式 接口服务")
public interface EnterWayConfigApi {


    @ApiOperation("配置-入驻方式列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "配置ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/enter-way-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListEnterWay>> list(@RequestParam(value = "coopConfigId") Long coopConfigId);


    @ApiOperation("配置-入驻方式更新")
    @RequestMapping(value = "/enter-way-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@RequestBody @Valid UpdateEnterWay input);

}
