package com.xforceplus.ant.coop.rule.center.client.api.canary;


import com.xforceplus.ant.coop.rule.center.client.data.canary.ClientCanaryRouteConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Describe: 灰度客户端-调用
 *
 * @Author xiezhongyong
 * @Date 2021-10-20
 */
@Api(value = "canary-cliens", description = "灰度客户端 接口服务")
public interface CanaryClientApi {

    @ApiOperation("获取单个灰度结果(always:灰度;never:非灰度)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryCode", value = "灰度代码", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "sellerTax", value = "销方公司税号", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "purchaserTenantId", value = "购方租户ID(可选)", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/canary-cliens/result", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> getCanary(@RequestParam("canaryCode") String canaryCode,
                                 @RequestParam("sellerTax") String sellerTax,
                                 @RequestParam(value = "purchaserTenantId", required = false) Long purchaserTenantId);

    @ApiOperation("获取多个税号灰度结果(always:灰度;never:非灰度)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryCode", value = "灰度代码", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "sellerTaxs", value = "销方公司税号列表", dataType = "List", paramType = "query", required = true),
            @ApiImplicitParam(name = "purchaserTenantId", value = "购方租户ID(可选)", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/canary-cliens/mult-taxno/result", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> getTaxNosCanary(@RequestParam("canaryCode") String canaryCode,
                                 @RequestParam("sellerTaxs") List<String> sellerTaxs,
                                 @RequestParam(value = "purchaserTenantId", required = false) Long purchaserTenantId);



    @ApiOperation("获取多个灰度结果(always:灰度;never:非灰度)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryCodes", value = "灰度代码列表(多个英文逗号‘,’分割)", dataType = "List", paramType = "query", required = true),
            @ApiImplicitParam(name = "sellerTax", value = "销方公司税号", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "purchaserTenantId", value = "购方租户ID(可选)", dataType = "Long", paramType = "query")}
    )


    @RequestMapping(value = "/canary-cliens/mult/result", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Map<String,String>> getMultCanary(@RequestParam("canaryCodes") List<String> canaryCodes,
                                                 @RequestParam("sellerTax") String sellerTax,
                                                 @RequestParam(value = "purchaserTenantId", required = false) Long purchaserTenantId);



    @ApiOperation("获取灰度路由配置对象")
    @RequestMapping(value = "/canary-cliens/route", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<ClientCanaryRouteConfig> getCanaryRouteConfig(@RequestParam("canaryType") String canaryType,
                                                             @RequestParam("canaryRouteKey") String canaryRouteKey);

}
