package com.xforceplus.ant.coop.rule.center.client.api.canary;


import com.xforceplus.ant.coop.rule.center.client.data.canary.request.UpdateCanaryConfigData;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.ListCanaryConfigData;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 灰度数据
 *
 * @Author xiezhongyong
 * @Date 2021-10-20
 */
@Api(value = "canary-config-datas", description = "灰度数据 接口服务")
public interface CanaryConfigDataApi {


    @ApiOperation("更新灰度数据状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-config-datas/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@PathVariable("id") Long id, @RequestBody @Valid UpdateCanaryConfigData input);


    @ApiOperation("删除灰度数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "ids", required = true, dataType = "List", paramType = "path")})
    @RequestMapping(value = "/canary-config-datas/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDelete(@PathVariable("ids") List<Long> ids);


    @ApiOperation("灰度数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "purchaserTenantId", value = "购方配置ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "canaryConfigId", value = "灰度配置ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "canaryConfigScopeId", value = "灰度配置范围ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "sellerTax", value = "销方税号", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "sellerCompanyName", value = "销方公司名称", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态(0:启用,1:停用)", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/canary-config-datas", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCanaryConfigData>> list(Page page,
                                                @RequestParam(value = "purchaserTenantId", required = false) Long purchaserTenantId,
                                                @RequestParam(value = "canaryConfigId", required = false) Long canaryConfigId,
                                                @RequestParam(value = "canaryConfigScopeId", required = false) Long canaryConfigScopeId,
                                                @RequestParam(value = "sellerTax", required = false) String sellerTax,
                                                @RequestParam(value = "sellerCompanyName", required = false) String sellerCompanyName,
                                                @RequestParam(value = "status", required = false) Integer status);


    @ApiOperation("刷新灰度数据")
    @RequestMapping(value = "/canary-config-datas/refresh", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> refreshCanaryData();


    @ApiOperation("同步旧的活动路由数据")
    @RequestMapping(value = "/canary-config-datas/sync/old/canaryroute/data", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> synOldCanaryData(String canaryCode, Long canaryConfigScopeId);





}
