package com.xforceplus.ant.coop.rule.center.client.api.canary;

import com.xforceplus.ant.coop.rule.center.client.data.canary.request.CreateCanaryConfigScope;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.GetCanaryConfigScope;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.ListCanaryConfigScope;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 灰度配置范围
 *
 * @Author xiezhongyong
 * @Date 2021-10-15
 */
@Api(value = "canary-config-scopes", description = "灰度配置范围 接口服务")
public interface CanaryConfigScopeApi {

    @ApiOperation("添加灰度配置范围")
    @RequestMapping(value = "/canary-config-scopes", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Object> create(@RequestBody @Valid CreateCanaryConfigScope input);

//    @ApiOperation("添加灰度配置范围扩展(使用于销方筛选配置拉平)")
//    @RequestMapping(value = "/canary-config-scopes/extend", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
//    BaseResult<String> createByExtend(@RequestBody JSONObject input);

    @ApiOperation("获取灰度配置范围详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-config-scopes/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetCanaryConfigScope> get(@PathVariable("id") Long id);

    @ApiOperation("灰度配置范围列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryConfigId", value = "灰度配置ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/canary-config-scopes", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListCanaryConfigScope>> list(@RequestParam(value = "canaryConfigId") Long canaryConfigId);

}
