package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.*;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务配置 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-31
 */
@Api(value = "biz-configs", description = "业务配置 接口服务", tags = {"业务配置相关业务-接口归类"})
public interface BizConfigApi {


    @ApiOperation("业务配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "数据ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "groupCode", value = "配置分组代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态(1:启用,0:停用)", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "configCode", value = "配置代码(英文字段名,支持模糊查询)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configName", value = "配置名称(中文字段名,支持模糊查询)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configSource", value = "配置来源(0-规则中心(默认) 1-业务配置)", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configGroupId", value = "业务配置分组ID", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/biz-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListBizConfig>> list(@SpringQueryMap Page page,
                                         @RequestParam(value = "id", required = false) Long id,
                                         @RequestParam(value = "coopConfigId") Long coopConfigId,
                                         @RequestParam(value = "applyRange", required = false) Integer applyRange,
                                         @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                         @RequestParam(value = "groupCode", required = false) String groupCode,
                                         @RequestParam(value = "status", required = false) Integer status,
                                         @RequestParam(value = "configCode", required = false) String configCode,
                                         @RequestParam(value = "configName", required = false) String configName,
                                         @RequestParam(value = "configSource", required = false) Integer configSource,
                                         @RequestParam(value = "configGroupId", required = false) Long configGroupId);

    @ApiOperation("获取业务配置详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetBizConfig> get(@PathVariable(value = "id") Long id);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true)}
    )
    @ApiOperation("配置分组下拉列表信息")
    @RequestMapping(value = "/biz-configs/group/options", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBizConfigGroup>> listBizConfigGroup(@RequestParam(value = "coopConfigId") Long coopConfigId);


    @ApiOperation("业务配置单据类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/bill-type", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listBillType(@PathVariable(value = "id") Long id);

    @ApiOperation("修改业务配置单据类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/bill-type", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBillType(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizConfigBillType input);

    @ApiOperation("修改业务配置状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/status", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizConfigStatus input);

    @ApiOperation("修改业务配置(具体配置内容)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/body", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBody(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizConfigBody input);

    @ApiOperation("修改业务配置条件(业务自身条件)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/condition", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateCondition(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizConfigCondition input);

    @ApiOperation("修改业务配置限定条件(业务头部条件)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/limiters", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateLimiters(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateLimiters input);


    @ApiOperation("修改业务配置关联对象信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{id}/bind-obj", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBindObj(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateTemplateBindObj input);


    @ApiOperation("添加业务配置")
    @RequestMapping(value = "/biz-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateBizConfig input);

    @ApiOperation("删除配置项")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "配置ID列表(不能为空,上限50)", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-configs/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> delete(@PathVariable(value = "ids") List<Long> ids);

}
