package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateDataTemplateItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateDataTemplateItemField;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.DataTemplateField;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetDataTemplateItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListDataItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListDataTemplateItem;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 数据模板明细 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "data-template-items", description = "数据模板明细 接口服务")
public interface DataTemplateItemApi {


    @ApiOperation("数据模板明细 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/data-template-items", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListDataTemplateItem>> list(@RequestParam(value = "templateId") Long templateId);


    @ApiOperation("更新数据模板明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-template-items/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateItem(@PathVariable("id") Long id, @RequestBody @Valid UpdateDataTemplateItem input);

    @ApiOperation("批量删除数据模板明细")
    @RequestMapping(value = "/data-template-items/batch", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDeleteTemplateItem(@RequestBody @ApiParam(name = "平台数据ID列表(格式：['1','2','3'])") List<Long> idList);

    @ApiOperation("获取数据模板明细 详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/data-template-items/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetDataTemplateItem> getTemplateItem(@PathVariable("id") Long id);

    @ApiOperation("数据模板添加字段 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/data-template-items/fields", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<DataTemplateField>> templateFields(@RequestParam(value = "templateId") Long templateId);


    @ApiOperation("更新数据模板字段")
    @RequestMapping(value = "/data-template-items/fields", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateFields(@RequestBody @Valid UpdateDataTemplateItemField input);

    @ApiOperation("关联数据模板明细列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateType", value = "模板类型(0:业务模板,1:检验模板,2: 业务配置,3:数据规则,4:业务配置分组)", dataType = "int", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/data-template-items/relevances", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListDataItem>> relevanceItems(@RequestParam(value = "templateId") Long templateId, @RequestParam(value = "templateType") Integer templateType);
}
