package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate.*;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 导出模板 API
 *
 * @Author xiezhongyong
 * @Date 2021-05-31
 */
@Api(value = "export-templates", description = "导出模板 接口服务")
public interface ExportTemplateApi {



    @ApiOperation("添加")
    @RequestMapping(value = "/export-templates", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateExportTemplate input);


    @ApiOperation("修改")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/export-templates/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateExportTemplate input);


    @ApiOperation("删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/export-templates/{id}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> delete(@PathVariable(value = "id") Long id);

    @ApiOperation("获取模板详情(带筛选配置)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联ID(购方租户ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模板类型", required = true, dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "billTypeName", value = "单据类型", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/export-templates/detail", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetExportTemplate> get(@RequestParam(value = "templateId") Long templateId,
                                      @RequestParam(value = "bindObjId") Long bindObjId,
                                      @RequestParam(value = "modelType") Integer modelType,
                                      @RequestParam(value = "billTypeName", required = false) String billTypeName);

    @ApiOperation("获取默认模板详情(不带筛选配置)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID(供应商公司ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联ID(购方租户ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模板类型", required = true, dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "billTypeName", value = "单据类型",  dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "businessType", required = true, value = "模板业务类型(BILL_EXP-结算单导出 INVOICE_EXP-发票导出)",  dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "defaultType", value = "默认类型(1:购方默认[购方不存在取系统默认],2:直接系统默认)",  dataType = "Integer", paramType = "query", defaultValue = "1")})
    @RequestMapping(value = "/export-templates/defaultDetail", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetExportTemplate> getDefault(@RequestParam(value = "configObjId") Long configObjId,
                                             @RequestParam(value = "bindObjId") Long bindObjId,
                                             @RequestParam(value = "modelType") Integer modelType,
                                             @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                             @RequestParam(value = "businessType") String businessType,
                                             @RequestParam(value = "defaultType", defaultValue = "1") Integer defaultType);


    @ApiOperation("模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID(供应商公司ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联ID(购方租户ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "billTypeName", value = "单据类型", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "businessType", required = true, value = "模板业务类型(BILL_EXP-结算单导出 INVOICE_EXP-发票导出)",  dataType = "String", paramType = "query")})
    @RequestMapping(value = "/export-templates", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListExportTemplate>> list(@RequestParam(value = "configObjId") Long configObjId,
                                              @RequestParam(value = "bindObjId") Long bindObjId,
                                              @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                              @RequestParam(value = "businessType") String businessType);





}
