package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.custtemplate.ExportTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * Describe: 导出模板配置读取
 *
 * @Author xiezhongyong
 * @Date 2021-06-02
 */
@Api(value = "export-template-dateils", description = "导出模板配置读取 接口服务")
public interface ExportTemplateConfigApi {

    @ApiOperation("获取供应商导出模板配置(后台业务使用)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联ID(购方租户ID)", required = true, dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模板类型", required = true, dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "billTypeName", value = "单据类型", dataType = "String", paramType = "query")})
    @RequestMapping(value = "/template-config/export", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<ExportTemplateDetail> getTemplateConfig(@RequestParam(value = "templateId") Long templateId,
                                                       @RequestParam(value = "bindObjId") Long bindObjId,
                                                       @RequestParam(value = "modelType") Integer modelType,
                                                       @RequestParam(value = "billTypeName", required = false) String billTypeName);

}
