package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.*;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 购方规则模板 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-26
 */
@Api(value = "rule-templates", description = "购方规则模板 接口服务")
public interface RuleTemplateApi {


    @ApiOperation("规则模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateClassId", value = "模板分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "billTypeId", value = "业务单类型ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "templateCode", value = "模板代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configSource", value = "配置来源(0-规则中心(默认) 1-业务配置)", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configGroupId", value = "业务配置分组ID", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/rule-templates", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListRuleTemplate>> list(@RequestParam(value = "coopConfigId") Long coopConfigId,
                                            @RequestParam(value = "templateClassId", required = false) Long templateClassId,
                                            @RequestParam(value = "billTypeId", required = false) Long billTypeId,
                                            @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                            @RequestParam(value = "templateCode", required = false) String templateCode,
                                            @RequestParam(value = "configSource", required = false) Integer configSource,
                                            @RequestParam(value = "configGroupId", required = false) Long configGroupId);

    @ApiOperation("获取规则模板详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetRuleTemplate> get(@PathVariable(value = "id") Long id);


    @ApiOperation("规则模板单据类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}/bill-type", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listBillType(@PathVariable(value = "id") Long id);

    @ApiOperation("修改规则模板单据类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}/bill-type", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBillType(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateRuleTemplateBillType input);

    @ApiOperation("修改规则模板关联对象信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}/bind-obj", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBindObj(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateTemplateBindObj input);

    @ApiOperation("修改规则模板状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}/status", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateRuleTemplateStatus input);


    @ApiOperation("添加规则模板")
    @RequestMapping(value = "/rule-templates", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateRuleTemplate input);

    @ApiOperation("修改规则模板限定条件(业务头部条件)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "配置ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{id}/limiters", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateLimiters(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateLimiters input);


    @ApiOperation("删除数据规则模板")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "配置ID列表(不能为空,上限50)", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/rule-templates/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> delete(@PathVariable(value = "ids") List<Long> ids);
}
