package com.xforceplus.ant.coop.rule.center.client.api.enterprise;

import com.xforceplus.ant.coop.rule.center.client.data.enterprise.response.AddTaxDeviceModel;
import com.xforceplus.ant.coop.rule.center.client.data.enterprise.response.TaxDeviceModel;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 企业税盘管理 API
 *
 */
@Api(value = "tax-device", description = "企业税盘管理 接口服务")
public interface TaxDeviceApi {

    @ApiOperation("添加协同配置")
    @RequestMapping(value = "/tax-device",method = RequestMethod.POST, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> create(@RequestBody @Valid AddTaxDeviceModel addTaxDeviceModel);

    @ApiOperation("协同配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tenantId", value = "租户ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "taxCode", value = "税号", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "deviceType", value = "设备类型(vukey:虚拟UKey设备)", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/tax-device",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<TaxDeviceModel>> list(@RequestParam(value = "tenantId", required = false) Long tenantId,
                                          @RequestParam(value = "taxCode", required = false) String taxCode,
                                          @RequestParam(value = "deviceType", required = false) String deviceType);
}
