package com.xforceplus.ant.coop.rule.center.client.api.log;


import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListCoopConfig;
import com.xforceplus.ant.coop.rule.center.client.data.log.request.CreateOperateLog;
import com.xforceplus.ant.coop.rule.center.client.data.log.response.ListOperateLog;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * Describe: 操作日志
 *
 * @Author xiezhongyong
 * @Date 2021/12/20
 */
@Api(value = "operate-logs", description = "操作日志 接口服务")
public interface OperateLogApi {

    @ApiOperation("日志列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "logGroup", value = "日志分组", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "functionCode", value = "功能代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "operateType", value = "操作类型", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/operate-logs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCoopConfig>> list(Page page, @RequestParam("logGroup") String logGroup,
                                          @RequestParam(value = "functionCode", required = false) String functionCode,
                                          @RequestParam(value = "operateType", required = false) String operateType);


    @ApiOperation("添加日志")
    @RequestMapping(value = "/operate-logs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateOperateLog operateLog);


}
