package com.xforceplus.ant.coop.rule.center.client.api.sc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * Describe: 业务配置 模板导入
 *
 * @Author xiezhongyong
 * @Date 2022/4/29
 */
@Api(value = "sc-import", description = "模板导入 接口服务")
public interface ImportConfigApi {


    @ApiOperation("菜单文件导入")
    @RequestMapping(value = "/import/menu", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> importMenu(@RequestParam("file") MultipartFile file, HttpServletRequest req);

    @ApiOperation("配置分组导入")
    @RequestMapping(value = "/import/config-group", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> importConfigGroup(@RequestParam("file") MultipartFile file, HttpServletRequest req);


}
