package com.xforceplus.ant.coop.rule.center.client.data.baseconfig;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * Describe: 计费方式 更新
 *
 * @Author xiezhongyong
 * @Date 2021-12-10
 */
@Data
public class UpdateFeeWay {
    @NotNull(message = "配置ID 不能为空")
    @ApiModelProperty("配置ID")
    private Long coopConfigId;

    @Valid
    @NotNull(message = "计费方式配置 不能为空")
    @ApiModelProperty("计费方式配置")
    private FeeConfig feeConfig;

    @Data
    public static class FeeConfig{
        @Pattern(regexp = "^PYT$|^PURCHASER$", message = "计费方式 不合法")
        @ApiModelProperty("计费方式(PYT:票易通完成缴费,PURCHASER:中心用户完成缴费)")
        private String feeWay;
        @ApiModelProperty("计费套餐包ID")
        private String feePackageId;
        @ApiModelProperty("计费套餐包名称")
        private String feePackageName;
    }
}
