package com.xforceplus.ant.coop.rule.center.client.data.baseconfig.enums;

import java.util.Arrays;

/**
 * Describe: 计费方式
 * @Author xiezhongyong
 * @Date 2020-03-31
 */
public enum FeeWayEnum {

    PYT("PYT", "票易通完成缴费"),
    PURCHASER("PURCHASER", "中心用户完成缴费")
    ;

    private final String code;
    private final String message;

    FeeWayEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static FeeWayEnum fromValue(String code) {
        return Arrays.stream(FeeWayEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
