package com.xforceplus.ant.coop.rule.center.client.data.baseconfig.tool;

import com.xforceplus.ant.coop.rule.center.client.api.baseconfig.FeeWayConfigApi;
import com.xforceplus.ant.coop.rule.center.client.data.baseconfig.GetFeeWay;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Optional;

/**
 * Describe: Describe: 基础配置 接口读取
 *
 * @Author xiezhongyong
 * @Date 2022/1/10
 */
@Slf4j
public class BaseConfigTool {


    /**
     * 获取配置方 计费配置
     * ps: 计费配置只有 购方配置才有
     *
     * @param api
     * @param configObjId
     * @return
     */
    public static Optional<GetFeeWay> getFeeWay(FeeWayConfigApi api, Long configObjId) {
        try {
            log.info("##### 读取计费配置请求: configObjId:{}", configObjId);
            BaseResult<GetFeeWay> response = api.get(configObjId);
            log.info("##### 读取计费配置响应: {}", JsonUtils.writeObjectToJson(response));
            if (!ResultCode.SUCCESS.code().equals(response.getCode())) {
                throw new RuntimeException("读取计费配置响应 code!=1");
            }
            if (null != response.getResult()) {
                return Optional.of(response.getResult());
            }
            return Optional.empty();

        } catch (Exception e) {
            log.error("##### 读取计费配置 异常：{}", e);
            throw e;
        }
    }

}
