package com.xforceplus.ant.coop.rule.center.client.data.canary.enums;


import java.util.Arrays;

/**
 * Describe: 灰度配置数据来源 状态列表 1:手工配置;2:定时器
 *
 * @Author xiezhongyong
 * @Date 2021-10-19
 */
public enum CanaryConfigDataSourceEnum {

    MANUAL(1, "手工配置"),
    TIMER(2, "定时器"),
    EXCEL(3, "EXCEL导入"),
    ENTER(4, "一站式入驻");

    private final Integer code;
    private final String msg;

    CanaryConfigDataSourceEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer code() {
        return code;
    }

    public String msg() {
        return msg;
    }

    public static CanaryConfigDataSourceEnum fromValue(Integer code) {
        return Arrays.stream(CanaryConfigDataSourceEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }

}
