package com.xforceplus.ant.coop.rule.center.client.data.canary.enums;

import java.util.Arrays;

/**
 * Describe: 灰度结果
 *
 * @Author xiezhongyong
 * @Date 2021-10-25
 */
public enum CanaryResultEnum {

    NEVER("never", "非灰度"),
    ALWAYS("always", "灰度");
    private final String code;
    private final String message;

    CanaryResultEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }


    public static CanaryResultEnum fromValue(String code) {
        return Arrays.stream(CanaryResultEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
