package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;

/**
 * Describe: 创建 灰度配置
 *
 * @Author xiezhongyong
 * @Date 2021-10-15
 */
@Data
public class CreateCanaryConfig {

    @Length(message = "灰度代码 最多输入50字符", max = 50)
    @NotEmpty(message = "灰度代码 不能为空")
    @ApiModelProperty("灰度代码")
    private String canaryCode;

    @Length(message = "灰度名称 最多输入100字符", max = 100)
    @NotEmpty(message = "灰度名称 不能为空")
    @ApiModelProperty("灰度名称")
    private String canaryName;

    @Length(message = "灰度描述 最多输入250字符", max = 250)
    @ApiModelProperty("灰度描述")
    private String canaryDesc;
}
